package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.AttendanceRuleExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.AttendanceRuleExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 考勤规则导出
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Component
public class AttendanceRuleExportProcess implements ExportProcess<AttendanceRuleExportVo> {

  @Autowired(required = false)
  private AttendanceRuleService attendanceRuleService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return AttendanceRuleExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_ATTENDANCE_RULE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA考勤规则导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    AttendanceRuleExportDto dto = this.convertParams(params);
    Page<AttendanceRuleEntity> entityPage = this.attendanceRuleService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    AttendanceRuleExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<AttendanceRuleEntity> page = this.attendanceRuleService.findByConditions(pageable, dto);
    //调整数据
    List<AttendanceRuleEntity> records = page.getRecords();
    return JSON.parseArray(JSON.toJSONString(adjustData(records)));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<AttendanceRuleExportVo> adjustData(List<AttendanceRuleEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.DICT_ENABLE));
    List<AttendanceRuleExportVo> exportVos = new ArrayList<>();
    for (AttendanceRuleEntity datum : data) {
      AttendanceRuleExportVo exportVo = new AttendanceRuleExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setModifyTime(DateUtil.formatDateTime(datum.getModifyTime()));
      exportVo.setEnableStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_ENABLE, datum.getEnableStatus()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private AttendanceRuleExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    AttendanceRuleExportDto dto = JSON.parseObject(JSON.toJSONString(params), AttendanceRuleExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
