package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.ClientPotentialExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.ClientPotentialExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.local.service.ClientPotentialService;
import com.biz.crm.sfa.business.client.sdk.dto.ClientPotentialPageDto;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjigne
 * @describe: 潜在客户导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class ClientPotentialExportProcess implements ExportProcess<ClientPotentialExportVo> {

  @Autowired
  private ClientPotentialService clientPotentialService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return ClientPotentialExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_CLIENT_POTENTIAL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA潜在客户导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    ClientPotentialExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<ClientPotential> page = this.clientPotentialService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    ClientPotentialPageDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<ClientPotential> page = this.clientPotentialService.findByConditions(pageable, dto);
    //调整数据
    List<ClientPotential> records = page.getRecords();
    List<ClientPotentialExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<ClientPotentialExportVo> adjustData(List<ClientPotential> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    //转换数据字典值
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(
        DictCodeConstant.DICT_CLIENT_TYPE
    ));
    List<ClientPotentialExportVo> exportVos = new ArrayList<>();
    for (ClientPotential datum : data) {
      ClientPotentialExportVo exportVo = new ClientPotentialExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setClientType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_CLIENT_TYPE, datum.getClientType()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private ClientPotentialExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    ClientPotentialExportDto dto = JSON.parseObject(JSON.toJSONString(params), ClientPotentialExportDto.class);
    return dto;
  }

}
