package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.ConclusionExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.ConclusionExportVo;
import com.biz.crm.sfa.business.conclusion.local.service.ConclusionVoService;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 工作总结导出
 *
 * @author jerry7
 */
@Component
public class ConclusionExportProcess implements ExportProcess<ConclusionExportVo> {

  @Autowired
  private ConclusionVoService conclusionVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return ConclusionExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_CONCLUSION_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA工作总结导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    ConclusionExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 1);
    Page<ConclusionVo> page = this.conclusionVoService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    ConclusionExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<ConclusionVo> page = this.conclusionVoService.findByConditions(pageable, dto);
    //调整数据
    List<ConclusionVo> records = page.getRecords();
    List<ConclusionExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<ConclusionExportVo> adjustData(List<ConclusionVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    return (List<ConclusionExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, ConclusionVo.class,ConclusionExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private ConclusionExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    ConclusionExportDto dto = JSON.parseObject(JSON.toJSONString(params), ConclusionExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
