package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.HelpDefenseDetailExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.HelpDefensePlanDetailExportVo;
import com.biz.crm.sfa.admin.web.report.service.HelpDefensePlanDetailReportVoService;
import com.biz.crm.sfa.admin.web.report.vo.HelpDefensePlanDetailReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 协访明细报表导出
 *
 * @author jerry7
 */
@Component
public class HelpDefenseDetailExportProcess implements ExportProcess<HelpDefensePlanDetailExportVo> {

  @Autowired(required = false)
  private HelpDefensePlanDetailReportVoService helpDefensePlanDetailReportVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return HelpDefensePlanDetailExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_HELP_DEFENSE_DETAIL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA协访明细报表导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    HelpDefenseDetailExportDto dto = this.convertParams(params);
    Page<HelpDefensePlanDetailReportVo> entityPage = this.helpDefensePlanDetailReportVoService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    HelpDefenseDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<HelpDefensePlanDetailReportVo> page = this.helpDefensePlanDetailReportVoService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<HelpDefensePlanDetailExportVo> adjustData(List<HelpDefensePlanDetailReportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return Lists.newArrayList();
    }
    return (List<HelpDefensePlanDetailExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, HelpDefensePlanDetailReportVo.class, HelpDefensePlanDetailExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private HelpDefenseDetailExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    HelpDefenseDetailExportDto dto = JSON.parseObject(JSON.toJSONString(params), HelpDefenseDetailExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
