package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.HelpDefenseExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.HelpDefenseExportVo;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefenseVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjigne
 * @describe: SFA协访计划指定导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class HelpDefenseExportProcess implements ExportProcess<HelpDefenseExportVo> {

  @Autowired
  private HelpDefenseVoService helpDefenseVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return HelpDefenseExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_HELP_DEFENSE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA协访计划制定导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    HelpDefenseExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<HelpDefenseVo> page = this.helpDefenseVoService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    HelpDefenseExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<HelpDefenseVo> page = this.helpDefenseVoService.findByConditions(pageable, dto);
    //调整数据
    List<HelpDefenseVo> records = page.getRecords();
    List<HelpDefenseExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<HelpDefenseExportVo> adjustData(List<HelpDefenseVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<HelpDefenseExportVo> exportVos = new ArrayList<>();
    for (HelpDefenseVo datum : data) {
      HelpDefenseExportVo exportVo = new HelpDefenseExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private HelpDefenseExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    HelpDefenseExportDto dto = JSON.parseObject(JSON.toJSONString(params), HelpDefenseExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
