package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.InventoryCheckExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.InventoryCheckExportVo;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import com.biz.crm.sfa.business.inventory.check.local.service.InventoryCheckService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 库存盘点导出
 *
 * @author jerry7
 */
@Component
public class InvntoryCheckExportProcess implements ExportProcess<InventoryCheckExportVo> {

  @Autowired
  private InventoryCheckService inventoryCheckService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return InventoryCheckExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_INVENTORY_CHECK_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA库存盘点导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    InventoryCheckExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 1);
    Page<InventoryCheckEntity> page = this.inventoryCheckService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    InventoryCheckExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<InventoryCheckEntity> page = this.inventoryCheckService.findByConditions(pageable, dto);
    //调整数据
    List<InventoryCheckEntity> records = page.getRecords();
    List<InventoryCheckExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<InventoryCheckExportVo> adjustData(List<InventoryCheckEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    return (List<InventoryCheckExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, InventoryCheckEntity.class,InventoryCheckExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private InventoryCheckExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    InventoryCheckExportDto dto = JSON.parseObject(JSON.toJSONString(params), InventoryCheckExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
