package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.OrderExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.OrderExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.service.OrderService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 签到组导出
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Component
public class OrderExportProcess implements ExportProcess<OrderExportVo> {

  @Autowired(required = false)
  private OrderService orderService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return OrderExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_ORDER_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA订单导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    OrderExportDto dto = this.convertParams(params);
    Page<OrderEntity> entityPage = this.orderService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    OrderExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<OrderEntity> page = this.orderService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<OrderExportVo> adjustData(List<OrderEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService
        .findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.ORDER_SOURCE));
    List<OrderExportVo> exportVos = new ArrayList<>();
    for (OrderEntity datum : data) {
      OrderExportVo exportVo = new OrderExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setSourceType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.ORDER_SOURCE, datum.getSourceType()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private OrderExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    OrderExportDto dto = JSON.parseObject(JSON.toJSONString(params), OrderExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
