package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.vo.StepFormExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.step.local.entity.StepForm;
import com.biz.crm.sfa.business.step.local.service.StepFormService;
import com.biz.crm.sfa.business.step.sdk.dto.StepFormPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjigne
 * @describe: 拜访步骤表单配置导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class StepFormExportProcess implements ExportProcess<StepFormExportVo> {

  @Autowired
  private StepFormService stepFormService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return StepFormExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_STEP_FORM_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA拜访步骤表单配置导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    StepFormPageDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<StepForm> page = this.stepFormService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    StepFormPageDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<StepForm> page = this.stepFormService.findByConditions(pageable, dto);
    //调整数据
    List<StepForm> records = page.getRecords();
    List<StepFormExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<StepFormExportVo> adjustData(List<StepForm> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    //转换数据字典值
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(
        DictCodeConstant.DICT_ENABLE,
        DictCodeConstant.DICT_CLIENT_TYPE,
        DictCodeConstant.DICT_TRUE_OR_FALSE,
        DictCodeConstant.DICT_VISIT_TYPE
    ));
    List<StepFormExportVo> exportVos = new ArrayList<>();
    for (StepForm datum : data) {
      StepFormExportVo exportVo = new StepFormExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setModifyTime(DateUtil.formatDateTime(datum.getModifyTime()));
      exportVo.setEnableStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_ENABLE, datum.getEnableStatus()));
      exportVo.setVisitType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_VISIT_TYPE, datum.getVisitType()));
      exportVo.setClientType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_CLIENT_TYPE, datum.getClientType()));
      exportVo.setLocateType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_TRUE_OR_FALSE, String.valueOf(datum.getLocateType())));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private StepFormPageDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    StepFormPageDto dto = JSON.parseObject(JSON.toJSONString(params), StepFormPageDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
