package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.VisitCompletionProgressMonthExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.VisitCompletionProgressMonthExportVo;
import com.biz.crm.sfa.admin.web.report.service.VisitCompletionProgressVoService;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @description: 拜访完成进度导出-月
 * @author: rentao
 * @date: 2022/7/8 10:53
 */
@Component
public class VisitCompletionProgressMonthExportProcess implements ExportProcess<VisitCompletionProgressMonthExportVo> {
  @Autowired
  private VisitCompletionProgressVoService visitCompletionProgressVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    VisitCompletionProgressMonthExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    Page<VisitCompletionProgressVo> page =
        this.visitCompletionProgressVoService.findMonthByConditions(pageable, dto);
    if (Objects.isNull(page.getTotal())) {
      return 0;
    }
    return Math.toIntExact(page.getTotal());
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    VisitCompletionProgressMonthExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<VisitCompletionProgressVo> page =
        this.visitCompletionProgressVoService.findMonthByConditions(pageable, dto);
    // 调整数据
    List<VisitCompletionProgressVo> records = page.getRecords();
    return JSON.parseArray(JSON.toJSONString(records));
  }

  @Override
  public Class<VisitCompletionProgressMonthExportVo> findCrmExcelVoClass() {
    return VisitCompletionProgressMonthExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "VISIT_COMPLETION_PROGRESS_MONTH";
  }

  @Override
  public String getBusinessName() {
    return "拜访完成进度-月";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private VisitCompletionProgressMonthExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    VisitCompletionProgressMonthExportDto dto =
        JSON.parseObject(JSON.toJSONString(params), VisitCompletionProgressMonthExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }
}
