package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.VisitEvaluateExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.VisitEvaluateExportVo;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 协访评价导出
 *
 * @author jerry7
 */
@Component
public class VisitEvaluateExportProcess implements ExportProcess<VisitEvaluateExportVo> {

  @Autowired
  private VisitEvaluateService visitEvaluateService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return VisitEvaluateExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_VISIT_EVALUATE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA协访评价导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    VisitEvaluateExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<VisitEvaluateEntity> page = this.visitEvaluateService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    VisitEvaluateExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<VisitEvaluateEntity> page = this.visitEvaluateService.findByConditions(pageable, dto);
    //调整数据
    List<VisitEvaluateEntity> records = page.getRecords();
    List<VisitEvaluateExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<VisitEvaluateExportVo> adjustData(List<VisitEvaluateEntity> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    return (List<VisitEvaluateExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, VisitEvaluateEntity.class, VisitEvaluateExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private VisitEvaluateExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    VisitEvaluateExportDto dto = JSON.parseObject(JSON.toJSONString(params), VisitEvaluateExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
