package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.VisitPlanDetailExceptionExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.VisitPlanDetailExceptionExportVo;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailExceptionVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 异常提报报表
 * @author: rentao
 * @date: 2022/7/8 16:55
 */
@Component
public class VisitPlanDetailExceptionExportProcess implements ExportProcess<VisitPlanDetailExceptionExportVo> {

  @Autowired
  private VisitPlanDetailExceptionVoService visitPlanDetailExceptionVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    VisitPlanDetailExceptionExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.visitPlanDetailExceptionVoService.findByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    VisitPlanDetailExceptionExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<VisitPlanDetailExceptionVo> page = this.visitPlanDetailExceptionVoService.findByConditions(pageable, dto);
    //调整数据
    List<VisitPlanDetailExceptionVo> records = page.getRecords();
    List<VisitPlanDetailExceptionExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<VisitPlanDetailExceptionExportVo> findCrmExcelVoClass() {
    return VisitPlanDetailExceptionExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_VISIT_PLAN_DETAIL_EXCEPTION_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "异常提报报表";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private VisitPlanDetailExceptionExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    VisitPlanDetailExceptionExportDto dto = JSON.parseObject(JSON.toJSONString(params), VisitPlanDetailExceptionExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<VisitPlanDetailExceptionExportVo> adjustData(List<VisitPlanDetailExceptionVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<VisitPlanDetailExceptionExportVo> exportVos = new ArrayList<>();
    for (VisitPlanDetailExceptionVo datum : data) {
      VisitPlanDetailExceptionExportVo exportVo = new VisitPlanDetailExceptionExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
