package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.VisitPlanExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.VisitPlanExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjigne
 * @describe: 拜访计划报表导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class VisitPlanExportProcess implements ExportProcess<VisitPlanExportVo> {

  @Autowired
  private VisitPlanService visitPlanService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return VisitPlanExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_VISIT_PLAN_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA拜访计划导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    VisitPlanExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    Page<VisitPlan> page = this.visitPlanService.findByConditions(pageable, dto);
    long total = page.getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    VisitPlanExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<VisitPlan> page = this.visitPlanService.findByConditions(pageable, dto);
    //调整数据
    List<VisitPlan> records = page.getRecords();
    List<VisitPlanExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<VisitPlanExportVo> adjustData(List<VisitPlan> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    //转换数据字典值
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.DICT_ENABLE, DictCodeConstant.DICT_VISIT_ROUTE_TYPE));
    List<VisitPlanExportVo> exportVos = new ArrayList<>();
    for (VisitPlan datum : data) {
      VisitPlanExportVo exportVo = new VisitPlanExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setModifyTime(DateUtil.formatDateTime(datum.getModifyTime()));
      exportVo.setEnableStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_ENABLE, datum.getEnableStatus()));
      exportVo.setVisitRouteType(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_VISIT_ROUTE_TYPE, datum.getVisitRouteType()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private VisitPlanExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    VisitPlanExportDto dto = JSON.parseObject(JSON.toJSONString(params), VisitPlanExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
