package com.biz.crm.sfa.admin.web.exports.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.sfa.admin.web.constant.DictCodeConstant;
import com.biz.crm.sfa.admin.web.exports.dto.VisitPlanLineExportDto;
import com.biz.crm.sfa.admin.web.exports.mapper.VisitPlanLineExportMapper;
import com.biz.crm.sfa.admin.web.exports.vo.VisitPlanLineExportVo;
import com.biz.crm.sfa.admin.web.utils.DictValueUtil;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author HanJiaJun
 * @describe: 新路组报表导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class VisitPlanLineExportProcess implements ExportProcess<VisitPlanLineExportVo> {

  @Autowired(required = false)
  private VisitPlanLineExportMapper exportMapper;
  @Autowired
  private VisitPlanLineService visitPlanLineService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Class findCrmExcelVoClass() {
    return VisitPlanLineExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_VISIT_PLAN_LINE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA线路组导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    VisitPlanLineExportDto dto = this.convertParams(params);
    return exportMapper.getExportTotal(dto);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    VisitPlanLineExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<VisitPlanLine> page = this.visitPlanLineService.findByConditions(pageable, dto);
    //调整数据
    List<VisitPlanLine> records = page.getRecords();
    List<VisitPlanLineExportVo> data = adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<VisitPlanLineExportVo> adjustData(List<VisitPlanLine> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    //转换数据字典值
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.DICT_ENABLE));
    List<VisitPlanLineExportVo> exportVos = new ArrayList<>();
    for (VisitPlanLine datum : data) {
      VisitPlanLineExportVo exportVo = new VisitPlanLineExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVo.setCreateTime(DateUtil.formatDateTime(datum.getCreateTime()));
      exportVo.setModifyTime(DateUtil.formatDateTime(datum.getModifyTime()));
      exportVo.setEnableStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_ENABLE, datum.getEnableStatus()));
      exportVos.add(exportVo);
    }
    return exportVos;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private VisitPlanLineExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    VisitPlanLineExportDto dto = JSON.parseObject(JSON.toJSONString(params), VisitPlanLineExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
