package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.WorkOverTimeExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.OvertimeExportVo;
import com.biz.crm.sfa.admin.web.report.service.WorkOverTimeVoService;
import com.biz.crm.sfa.admin.web.report.vo.OvertimeReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 加班汇总导出
 *
 * @author jerry7
 */
@Component
public class WorkOvertTimeExportProcess implements ExportProcess<OvertimeExportVo> {

  @Autowired(required = false)
  private WorkOverTimeVoService workOverTimeVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class findCrmExcelVoClass() {
    return OvertimeExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_WORK_OVERTIME_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "SFA加班汇总导出";
  }

  @Override
  public Integer getTotal(Map<String, Object> params) {
    WorkOverTimeExportDto dto = this.convertParams(params);
    Page<OvertimeReportVo> entityPage = this.workOverTimeVoService.findByConditions(PageRequest.of(0, 1), dto);
    return ((int) (entityPage.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    WorkOverTimeExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<OvertimeReportVo> page = this.workOverTimeVoService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<OvertimeExportVo> adjustData(List<OvertimeReportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return Lists.newArrayList();
    }
    return (List<OvertimeExportVo>) this.nebulaToolkitService.copyCollectionByWhiteList(data, OvertimeReportVo.class, OvertimeExportVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private WorkOverTimeExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    WorkOverTimeExportDto dto = JSON.parseObject(JSON.toJSONString(params), WorkOverTimeExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

}
