package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * TPM活动执行信息导出vo
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Data
@CrmExcelExport
@ApiModel(value = "ActionTpmExecuteExportVo", description = "TPM活动执行信息导出vo")
public class ActionTpmExecuteExportVo extends CrmExcelVo {

  /**
   * TPM活动编码
   */
  @CrmExcelColumn("活动编码")
  private String actionCode;

  /**
   * TPM活动名称
   */
  @CrmExcelColumn("活动名称")
  private String actionName;

  /**
   * 终端编码
   */
  @CrmExcelColumn("客户编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @CrmExcelColumn("客户名称")
  private String terminalName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("提交时间")
  private String createTime;

  /**
   * TPM活动开始时间
   */
  @CrmExcelColumn("活动开始时间")
  private String actionStartDate;

  /**
   * TPM活动结束时间
   */
  @CrmExcelColumn("活动结束时间")
  private String actionEndDate;

  /**
   * 创建人
   */
  @CrmExcelColumn("执行人姓名")
  private String createName;

  /**
   * 提交人职位名称
   */
  @CrmExcelColumn("人职位名称")
  private String postName;

  /**
   * 提交人职位名称
   */
  @CrmExcelColumn("所属组织")
  private String orgName;
}
