package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @description: 补打卡申请明细导出Vo
 * @author: rentao
 * @date: 2022/7/8 16:32
 */
@Data
@CrmExcelExport
@ApiModel(value = "AttendanceFillApplyExportVo", description = "补打卡申请明细导出Vo")
public class AttendanceFillApplyExportVo extends CrmExcelVo {

  /**
   * 申请原因
   */
  @CrmExcelColumn("申请原因")
  private String applyReason;

  /**
   * 人员账号
   */
  @CrmExcelColumn("人员账号")
  private String userName;

  /**
   * 人员名称
   */
  @CrmExcelColumn("人员名称")
  private String userRealName;

  /**
   * 职位编码
   */
  @CrmExcelColumn("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @CrmExcelColumn("职位名称")
  private String positionName;

  /**
   * 所属组织编码
   */
  @CrmExcelColumn("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @CrmExcelColumn("所属组织名称")
  private String orgName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @CrmExcelColumn("申请日期(yyyy-MM-dd HH:mm:ss)")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @CrmExcelColumn("开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @CrmExcelColumn("结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 异常打卡记录集合
   */
  @CrmExcelColumn("异常打卡记录集合")
  private String recordIds;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @CrmExcelColumn("考勤日期(yyyy-MM-dd)")
  private String ruleDate;

  /**
   * 打卡类型
   */
  @CrmExcelColumn("打卡类型")
  private String clockType;

  /**
   * 审批状态
   */
  @CrmExcelColumn("审批状态")
  private String processStatus;

  /**
   * 审批备注
   */
  @CrmExcelColumn("审批备注")
  private String processRemark;

  /**
   * 审批流程编码
   */
  @CrmExcelColumn("审批流程编码")
  private String processKey;

  /**
   * 审批单号
   */
  @CrmExcelColumn("审批单号")
  private String processNumber;
}
