package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @description: 月度考勤报表导出Vo
 * @author: rentao
 * @date: 2022/7/8 16:15
 */
@Data
@ApiModel(value = "AttendanceRecordMonthExportVo", description = "月度考勤报表导出Vo")
public class AttendanceRecordMonthExportVo extends CrmExcelVo {

  @CrmExcelColumn("考勤日期(yyyy)")
  private String ruleYear;

  @CrmExcelColumn("考勤日期(MM)")
  private String ruleMonth;

  @CrmExcelColumn("账号")
  private String userName;

  @CrmExcelColumn("人员姓名")
  private String fullName;

  @CrmExcelColumn("职位编码")
  private String positionCode;

  @CrmExcelColumn("职位名称")
  private String positionName;

  @CrmExcelColumn("组织编码")
  private String orgCode;

  @CrmExcelColumn("组织名称")
  private String orgName;

  @CrmExcelColumn("正常出勤")
  private BigDecimal normal;

  @CrmExcelColumn("休息")
  private BigDecimal offDays;

  @CrmExcelColumn("加班")
  private BigDecimal overtimeDays;

  @CrmExcelColumn("请假")
  private BigDecimal leaveDays;

  @CrmExcelColumn("迟到")
  private Integer lateDays;

  @CrmExcelColumn("早退")
  private Integer earlyDays;

  @CrmExcelColumn("旷工")
  private BigDecimal absenteeismDays;

  @CrmExcelColumn("总时长")
  private BigDecimal allTimes;
}
