package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionFileVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 工作总结VO
 *
 * @author jerry7
 */
@Data
@ApiModel("工作总结返回VO")
public class ConclusionExportVo extends CrmExcelVo {

  /**
   * 总结类别：日报/周报/月报/心得
   */
  @ApiModelProperty("总结类别：日报/周报/月报/心得")
  private String conclusionType;

  /**
   * 总结内容
   */
  @ApiModelProperty("总结内容")
  private String conclusionContent;

  /**
   * 工作计划
   */
  @ApiModelProperty("工作计划")
  private String workPlan;

  /**
   * 可见范围
   */
  @ApiModelProperty("可见范围")
  private String visibleScopeType;

  /**
   * 工作总结文件列表
   */
  @ApiModelProperty("工作总结文件列表")
  private List<ConclusionFileVo> conclusionFileList;

  /**
   * 指定可见人编码列表
   */
  @ApiModelProperty("指定可见人编码列表")
  private List<String> visibleScope;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private String longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private String latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String conclusionAddress;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgName;

  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", value = "创建人账号")
  private String createAccount;

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", value = "创建人名称")
  private String createName;
}
