package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 节假日导出vo
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Data
@CrmExcelExport
@ApiModel(value = "HolidayExportVo", description = "节假日导出vo")
public class HolidayExportVo extends CrmExcelVo {

  /**
   * 年份
   */
  @CrmExcelColumn("年份")
  private String year;

  /**
   * 法定节假日天数
   */
  @CrmExcelColumn("法定节假日天数")
  private Integer holidayDays;

  /**
   * 计算薪资天数
   */
  @CrmExcelColumn("计算薪资天数")
  private Integer salaryDays;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;
}
