package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @description: 积分明细导出vo
 * @author: rentao
 * @date: 2022/7/8 15:24
 */
@Data
@CrmExcelExport
@ApiModel(value = "IntegralExportVo", description = "积分明细导出vo")
public class IntegralExportVo extends CrmExcelVo {

  @CrmExcelColumn("积分规则编码")
  private String integralRuleCode;

  @CrmExcelColumn("积分规则名称")
  private String integralRuleName;

  @CrmExcelColumn("年月")
  private String integralYearMonth;

  @CrmExcelColumn("积分数")
  private Integer integralNum;

  @CrmExcelColumn("积分任务类型编码")
  private String integralTaskTypeCode;

  @CrmExcelColumn("积分任务类型名称")
  private String integralTaskTypeName;

  @CrmExcelColumn("创建人岗位名称")
  private String createPosName;

  @CrmExcelColumn("创建人岗位")
  private String createPosCode;

  @CrmExcelColumn("创建人组织")
  private String createOrgCode;

  @CrmExcelColumn("创建人组织名称")
  private String createOrgName;

  @CrmExcelColumn("职位级别编码")
  private String createPositionLevelCode;

  @CrmExcelColumn("职位级别编码")
  private String createPositionLevelName;
}
