package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 订单导出vo
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Data
@CrmExcelExport
@ApiModel(value = "OrderExportVo", description = "订单导出vo")
public class OrderExportVo extends CrmExcelVo {

  /**
   * 订单编码
   */
  @CrmExcelColumn("订单号")
  private String orderCode;

  /**
   * 来源类型
   *
   * @see com.biz.crm.sfa.business.order.sdk.enums.OrderSourceType
   */
  @CrmExcelColumn("订单来源类型")
  private String sourceType;

  /**
   * 终端编码
   */
  @CrmExcelColumn("客户编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @CrmExcelColumn("客户名称")
  private String terminalName;

  /**
   * 创建人
   */
  @CrmExcelColumn("人员名称")
  private String createName;

  /**
   * 提交人职位名称
   */
  @CrmExcelColumn("职位名称")
  private String postName;

  /**
   * 提交人所属组织
   */
  @CrmExcelColumn("所属组织")
  private String orgName;
}
