package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyTimeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 加班详情信息Vo
 * @author jerry7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OvertimeDetailExportVo", description = "加班详情导出Vo")
public class OvertimeDetailExportVo extends CrmExcelVo {

  private static final long serialVersionUID = -7262877802300944536L;

  /**
   * 加班调整类型(normal普通调整，legal节假日调整)
   *
   * @see com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeType
   */
  @ApiModelProperty("加班调整类型")
  private String overtimeType;

  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  private String applyCode;

  /**
   * 申请原因
   */
  @ApiModelProperty( "申请原因")
  private String applyReason;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:ss)")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 申请时长(天)
   */
  @ApiModelProperty("申请时长(天)")
  private BigDecimal applyDuration;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员名称
   */
  @ApiModelProperty("人员名称")
  private String userRealName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 审批通过时间(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("审批通过时间(yyyy-MM-dd HH:mm:ss)")
  private String auditPassDate;

  /**
   * 日期时间明细
   */
  @ApiModelProperty("日期时间明细")
  private List<OvertimeApplyTimeVo> timeList;

  /**
   * 节假日天数
   */
  @ApiModelProperty("节假日天数")
  private BigDecimal holidayDays;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String parentOrgName;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 审批备注
   */
  @ApiModelProperty("审批备注")
  private String processRemark;
}
