package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 请假申请汇总报表导出vo
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel("请假申请汇总导出vo")
public class SfaLeaveSummaryExportVo extends CrmExcelVo {

    /**
     * 人员账号
     */
    @ApiModelProperty("人员账号 人员账号")
    private String userName;
    /**
     * 人员姓名
     */
    @ApiModelProperty("人员姓名 人员姓名")
    private String realName;
    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称 职位名称")
    private String posName;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String parentOrgName;
    /**
     * 办事处
     */
    @ApiModelProperty("办事处")
    private String orgName;
    /**
     * 年假天数
     */
    @ApiModelProperty("年假")
    private BigDecimal annualLeave = new BigDecimal(0);
    /**
     * 事假天数
     */
    @ApiModelProperty("事假")
    private BigDecimal personalLeave = new BigDecimal(0);
    /**
     * 婚假天数
     */
    @ApiModelProperty("婚假")
    private BigDecimal marriageLeave = new BigDecimal(0);
    /**
     * 丧假天数
     */
    @ApiModelProperty("丧假")
    private BigDecimal funeralLeave = new BigDecimal(0);
    /**
     * 陪产假天数
     */
    @ApiModelProperty("陪产假")
    private BigDecimal paternityLeave = new BigDecimal(0);
    /**
     * 调休天数
     */
    @ApiModelProperty("调休")
    private BigDecimal daysOff = new BigDecimal(0);
    /**
     * 病假天数
     */
    @ApiModelProperty("病假")
    private BigDecimal sickLeave = new BigDecimal(0);
    /**
     * 产假天数
     */
    @ApiModelProperty("产假")
    private BigDecimal maternityLeave = new BigDecimal(0);
}
