package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 拜访步骤表单配置导出vo
 *
 * @author songjingen
 */
@Data
@CrmExcelExport
@ApiModel(value = "StepFormExportVo", description = "拜访步骤表单配置导出vo")
public class StepFormExportVo extends CrmExcelVo {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 步骤编码
   */
  @CrmExcelColumn("步骤编码")
  private String stepCode;

  /**
   * 步骤名称
   */
  @CrmExcelColumn("步骤名称")
  private String stepName;

  /**
   * 拜访类型
   *
   * @see VisitTypeEnum#getDictCode()
   */
  @CrmExcelColumn("拜访类型")
  private String visitType;

  @CrmExcelColumn("客户类型")
  private String clientType;

  /**
   * 表单名称
   */
  @CrmExcelColumn("表单名称")
  private String formName;

  /**
   * 客户细类
   * 取字典编码为经销商：customer_type、终端：terminal_type的数据
   */
  @CrmExcelColumn("客户细类")
  private String clientSubType;

  /**
   * 有效期开始日期
   */
  @CrmExcelColumn("有效期开始日期")
  private String startTime;

  /**
   * 有效期结束日期
   */
  @CrmExcelColumn("有效期结束日期")
  private String endTime;

  /**
   * 是否获取定位信息
   */
  @CrmExcelColumn("是否获取定位信息")
  private String locateType;


  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 备注
   */
  @CrmExcelColumn("备注")
  private String remark;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;

}
