package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @description: 拜访完成进度导出vo
 * @author: rentao
 * @date: 2022/7/8 10:54
 */
@Data
@CrmExcelExport
@ApiModel(value = "VisitCompletionProgressExportVo", description = "拜访完成进度导出vo")
public class VisitCompletionProgressExportVo extends CrmExcelVo {

  @CrmExcelColumn("人员姓名")
  private String realName;

  @CrmExcelColumn("人员账号")
  private String userName;

  @CrmExcelColumn("职位名称")
  private String postName;

  @CrmExcelColumn("职位编码")
  private String postCode;

  @CrmExcelColumn("职位编码")
  private String orgCode;

  @CrmExcelColumn("职位名称")
  private String orgName;

  @CrmExcelColumn("日期")
  private String visitDate;

  @CrmExcelColumn("拜访计划数量")
  private Long visitCount;

  @CrmExcelColumn("拜访计划完成数")
  private Long visitComplet;

  @CrmExcelColumn("拜访计划未完成数")
  private Long visitNoComplet;

  @CrmExcelColumn("拜访计划进行中")
  private Long visitUnder;

  @CrmExcelColumn("拜访计划异常数")
  private Long visitException;

  @CrmExcelColumn("拜访计划百分比")
  private String visitPercentum;

  @CrmExcelColumn("协访计划数量")
  private Long helpCount;

  @CrmExcelColumn("协访完成数量")
  private Long helpComplet;

  @CrmExcelColumn("协访未完成数量")
  private Long helpNoComplet;

  @CrmExcelColumn("协访异常")
  private Long helpException;

  @CrmExcelColumn("协访进行中")
  private Long helpUnder;

  @CrmExcelColumn("协访百分比")
  private String helpPercentum;

}
