package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @description: 异常提报报表vo
 * @author: rentao
 * @date: 2022/7/8 16:52
 */
@Data
@CrmExcelExport
@ApiModel(value = "VisitPlanDetailExceptionExportVo", description = "异常提报报表vo")
public class VisitPlanDetailExceptionExportVo extends CrmExcelVo {

  /**
   * 客户编码
   */
  @CrmExcelColumn("客户编码")
  private String clientCode;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @CrmExcelColumn("客户类型")
  private String clientType;

  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  private String clientName;

  /**
   * 异常信息
   */
  @CrmExcelColumn("异常信息")
  private String remark;

  /**
   * 人员职位编码
   */
  @CrmExcelColumn("人员职位编码")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @CrmExcelColumn("人员职位名称")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @CrmExcelColumn("人员所属组织编码")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @CrmExcelColumn("人员所属组织名称")
  private String visitOrgName;
}
