package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 线路组导出vo
 *
 * @author sunx
 * @date 2022/5/13
 */
@Data
@CrmExcelExport
@ApiModel(value = "VisitPlanLineExportVo", description = "线路组导出vo")
public class VisitPlanLineExportVo extends CrmExcelVo {

  /**
   * 线路组名称
   */
  @CrmExcelColumn("线路组名称")
  private String lineName;

  /**
   * 人员账号
   */
  @CrmExcelColumn("人员账号")
  private String userName;

  /**
   * 人员姓名
   */
  @CrmExcelColumn("人员姓名")
  private String fullName;

  /**
   * 职位名称
   */
  @CrmExcelColumn("职位名称")
  private String postName;

  /**
   * 所属组织名称
   */
  @CrmExcelColumn("所属组织名称")
  private String orgName;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("状态")
  private String enableStatus;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  private String modifyTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;
}
