package com.biz.crm.sfa.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @description: （临时）工作任务导出
 * @author: rentao
 * @date: 2022/7/8 14:41
 */
@Data
@CrmExcelExport
@ApiModel(value = "WorkTaskReportExportVo", description = "（临时）工作任务导出Vo")
public class WorkTaskReportExportVo extends CrmExcelVo {

  @CrmExcelColumn("任务编码")
  private String taskCode;

  @CrmExcelColumn("任务标题")
  private String taskTitle;

  @CrmExcelColumn("发布时间")
  private String releaseDate;

  @CrmExcelColumn("开始时间")
  private String startDate;

  @CrmExcelColumn("截至时间")
  private String endDate;

  @CrmExcelColumn("任务详情")
  private String content;

  @CrmExcelColumn("任务发送人")
  private String senderName;

  @CrmExcelColumn("任务发送人职位名称")
  private String senderPosName;

  @CrmExcelColumn("任务发送人职位编码")
  private String senderPosCode;

  @CrmExcelColumn("任务地点")
  private String taskSite;

  @CrmExcelColumn("执行状态 0待执行 1已完成 2已回绝 3已过期")
  private String executeStatus;

  @CrmExcelColumn("任务接收人")
  private String receverName;

  @CrmExcelColumn("接收人账号")
  private String receverCode;

  @CrmExcelColumn("任务执行时间")
  private String receveDate;

  @CrmExcelColumn("执行是定位地址")
  private String address;

  @CrmExcelColumn("任务接收总结")
  private String summary;

  @CrmExcelColumn("执行人组织编码")
  private String receverOrgCode;

  @CrmExcelColumn("执行人组织名称")
  private String receverOrgName;

  @CrmExcelColumn("执行人职位编码")
  private String receverPosCode;

  @CrmExcelColumn("执行人职位名称")
  private String receverPosName;

  @CrmExcelColumn("任务状态 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期")
  private String taskStatus;
}
