package com.biz.crm.sfa.admin.web.imports.client.serive;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.sfa.admin.web.imports.client.model.ClientPotentialImportVo;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.local.service.ClientPotentialService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 潜在客户池导入
 *
 * @author songjingen
 * @date 2022/7/29
 */
@Component
@Slf4j
public class ClientPotentialImportProcess implements ImportProcess<ClientPotentialImportVo> {

  @Autowired(required = false)
  private ClientPotentialService clientPotentialService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public Map<Integer, String> execute(
      LinkedHashMap<Integer, ClientPotentialImportVo> data,
      TaskGlobalParamsVo paramsVo,
      Map<String, Object> params) {
    List<ClientPotentialImportVo> collect = (List<ClientPotentialImportVo>) data.values();
    if (CollectionUtils.isEmpty(collect)) {
      return null;
    }
    List<ClientPotential> clientPotentials = (List<ClientPotential>) this.nebulaToolkitService.copyCollectionByWhiteList(collect, ClientPotentialImportVo.class, ClientPotential.class, HashSet.class, ArrayList.class);
    this.clientPotentialService.createBatch(clientPotentials);
    return null;
  }

  @Override
  public Class findCrmExcelVoClass() {
    return ClientPotentialImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "SFA_CLIENT_POTENTIAL_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "潜在客户导入 ";
  }
}