package com.biz.crm.sfa.admin.web.mobile.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.mobile.dto.ClientDto;
import com.biz.crm.sfa.admin.web.mobile.service.ClientVoService;
import com.biz.crm.sfa.admin.web.mobile.vo.ClientVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户管理相关的http接口
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
@RestController
@RequestMapping("/v1/mobile/clientVo")
@Slf4j
@Api(tags = "客户信息:clientVo:客户信息")
public class ClientVoController {
  /**
   * 服务对象
   */
  @Autowired
  private ClientVoService clientVoService;

  /**
   * 通过条件分页查询客户信息列表
   *
   * @param dto 查询条件
   * @return
   */
  @ApiOperation(value = "通过条件分页查询客户信息列表")
  @GetMapping("findByConditions")
  public Result<Page<ClientVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "ClientDto", value = "分页Dto") ClientDto dto) {
    try {
      Page<ClientVo> page = this.clientVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取当前用户指定日期未拜访的客户信息列表
   *
   * @param pageable
   * @param dto      查询条件
   * @return
   */
  @ApiOperation("获取当前用户指定日期未拜访的客户信息列表")
  @GetMapping("findNotVisitClientByVisitDate")
  public Result<Page<ClientVo>> findNotVisitClientByVisitDate(@PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "dto", value = "分页Dto") ClientDto dto) {
    try {
      Page<ClientVo> page = this.clientVoService.findNotVisitClientByVisitDate(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
