package com.biz.crm.sfa.admin.web.mobile.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 客户信息dto
 *
 * @author songjingen
 */
@EqualsAndHashCode(callSuper = false)
@Data
@ApiModel(value = "ClientDto", description = "客户信息dto")
public class ClientDto {

  private static final long serialVersionUID = 5323221664981825624L;

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String clientName;

  /**
   * 客户类型
   */
  @ApiModelProperty(value = "客户类型:terminal-终端，dealer-经销商")
  private String clientType;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字（客户 编码 联系人）")
  private String keyWord;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 客户细类类型
   */
  @ApiModelProperty("客户细类")
  private String clientSubType;

  /**
   * 排除客户编码集合
   */
  @ApiModelProperty(value = "排除客户编码集合", hidden = true)
  private List<String> excludeClientList;

  /**
   * 拜访日期
   */
  @ApiModelProperty("拜访日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date visitDate;

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号")
  private String userName;

}