package com.biz.crm.sfa.admin.web.mobile.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 附近客户 请求dto
 *
 * @author songjingen
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NearbyClientDto", description = "附近客户 ")
public class NearbyClientDto {

  /**
   * 经纬度
   */
  @ApiModelProperty("当前经纬度，格式104.10194,30.65984")
  private String location;

  /**
   * 每页数据的数量
   */
  @ApiModelProperty("每页数据的数量")
  private Integer size;

  /**
   * 页码
   */
  @ApiModelProperty("页码")
  private Integer page;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 时间
   */
  @ApiModelProperty("时间(yyyy-MM-dd)")
  private String visitTime;

}
