package com.biz.crm.sfa.admin.web.mobile.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeMappingVo;
import com.biz.crm.sfa.admin.web.mobile.service.CycleVisitPlanLineRouteVoService;
import com.biz.crm.sfa.admin.web.mobile.vo.CycleVisitPlanLineRouteVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.register.VisitPlanLineRouteRegister;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeMappingService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 周期性线路组拜访计划报表实现类
 *
 * @author songjingen
 */
@Service
public class CycleVisitPlanLineRouteVoServiceImpl implements CycleVisitPlanLineRouteVoService {

  @Autowired
  private VisitPlanService visitPlanService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private VisitPlanLineRouteRegister visitPlanLineRouteRegister;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private VisitPlanLineRangeMappingService visitPlanLineRangeMappingService;

  @Override
  public Page<CycleVisitPlanLineRouteVo> findByConditions(Pageable pageable, String visitUserName) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    VisitPlanQueryDto visitPlanQueryDto = new VisitPlanQueryDto();
    if (StringUtils.isBlank(visitUserName)) {
      LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
      visitPlanQueryDto.setVisitUserName(loginDetails.getAccount());
    } else {
      visitPlanQueryDto.setVisitUserName(visitUserName);
    }
    visitPlanQueryDto.setTenantCode(TenantUtils.getTenantCode());
    visitPlanQueryDto.setVisitRouteType(visitPlanLineRouteRegister.getKey());
    Page<VisitPlan> page = this.visitPlanService.findByConditions(pageable, visitPlanQueryDto);
    if (page == null) {
      return new Page<>();
    }
    List<VisitPlan> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    List<CycleVisitPlanLineRouteVo> cycleVisitPlanLineRouteVos = (List<CycleVisitPlanLineRouteVo>) this.nebulaToolkitService.copyCollectionByWhiteList(records, VisitPlan.class, CycleVisitPlanLineRouteVo.class, HashSet.class, ArrayList.class);
    List<String> visitPlanCodes = cycleVisitPlanLineRouteVos.stream().map(CycleVisitPlanLineRouteVo::getVisitPlanCode).collect(Collectors.toList());
    Map<String, List<VisitPlanLineRangeMapping>> map = this.visitPlanLineRangeMappingService.findByVisitPlanCodesStuMap(visitPlanCodes);
    for (CycleVisitPlanLineRouteVo cycleVisitPlanLineRouteVo : cycleVisitPlanLineRouteVos) {
      List<VisitPlanLineRangeMapping> visitPlanLineRangeMappings = map.get(cycleVisitPlanLineRouteVo.getVisitPlanCode());
      if (!CollectionUtils.isEmpty(visitPlanLineRangeMappings)) {
        List<VisitPlanLineRangeMappingVo> visitPlanLineRangeMappingVos = (List<VisitPlanLineRangeMappingVo>) this.nebulaToolkitService.copyCollectionByWhiteList(visitPlanLineRangeMappings, VisitPlanLineRangeMapping.class, VisitPlanLineRangeMappingVo.class, HashSet.class, ArrayList.class);
        cycleVisitPlanLineRouteVo.setMappingVos(visitPlanLineRangeMappingVos);
      }
    }
    Page<CycleVisitPlanLineRouteVo> voPage = new Page<>();
    BeanUtils.copyProperties(page, voPage);
    voPage.setRecords(cycleVisitPlanLineRouteVos);
    return voPage;
  }
}
