package com.biz.crm.sfa.admin.web.mobile.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 终端客户信息vo
 *
 * @author songjingen
 */
@Data
@ApiModel(value = "终端客户信息vo")
public class ClientVo implements Serializable {
  private static final long serialVersionUID = -1592215361922098633L;

  /**
   * 客户id
   */
  @ApiModelProperty("客户id")
  private String id;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;
  /**
   * 联系人信息
   */
  @ApiModelProperty("联系人信息")
  private List<ClientContactVo> clientContactVos;
  /**
   * 客户细类类型
   */
  @ApiModelProperty("客户细类")
  private String clientSubType;
  /**
   * 网点地址
   */
  @ApiModelProperty("客户地址")
  private String clientAddress;
  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private List<String> clientTags;
  /**
   * 经度
   */
  @ApiModelProperty("网点经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("网点纬度")
  private BigDecimal latitude;

  /**
   * 未拜访天数
   */
  @ApiModelProperty("未拜访天数")
  private Integer visitCount;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  private String shopImagePath;
}
