package com.biz.crm.sfa.admin.web.mobile.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeMappingVo;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitPlanTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.register.VisitPlanRouteRegister;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 周期性拜访计划(线路组)
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CycleVisitPlanLineRouteVo", description = "周期性拜访计划(线路组)")
public class CycleVisitPlanLineRouteVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  private String visitPlanCode;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  private String visitOrgName;

  /**
   * 拜访类型  临时拜访-计划外，计划拜访-计划内
   * <p>
   * {@link VisitPlanTypeEnum#getDictCode()}
   */
  @ApiModelProperty("拜访计划类型")
  private String visitPlanType;

  /**
   * 维度类型 维度类型（线路组、网点、频率）
   * <p>
   * {@link VisitPlanRouteRegister#getKey()}
   */
  @ApiModelProperty("拜访维度类型")
  private String visitRouteType;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date startDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date endDate;

  /**
   * 关联线路组
   */
  @ApiModelProperty("关联线路组")
  private List<VisitPlanLineRangeMappingVo> mappingVos;
}
