package com.biz.crm.sfa.admin.web.notifier;

import com.biz.crm.business.common.local.config.DefaultLoginAuthenticationConfig;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 获取当前登陆者所具备的角色（roleCode）
 *
 * @author pengxi
 * @date 2021/12/07
 */
@Component("AuthenticationUserEventListenerImpl")
public class AuthenticationUserEventListenerImpl implements AuthenticationUserEventListener {

  @Autowired(required = false)
  private UserVoService userVoService;

  @Autowired(required = false)
  private PositionVoService positionVoService;
  @Autowired
  private DefaultLoginAuthenticationConfig defaultLoginAuthenticationConfig;

  @Override
  public Set<String> onRequestRoleCodes(String tenantCode, String account) {
    if (StringUtils.isBlank(tenantCode) || StringUtils.isBlank(account)) {
      return Sets.newHashSet();
    }
    this.defaultLoginAuthenticationConfig.defaultAdminAuthentication();
    try {
      Set<String> positionCodes = this.userVoService.findPositionCodesByUserNames(Lists.newArrayList(account));
      if (CollectionUtils.isEmpty(positionCodes)) {
        return Sets.newHashSet();
      }
      return this.positionVoService.findRolesByPositionCodes(Lists.newArrayList(positionCodes));
    } finally {
      SecurityContextHolder.clearContext();
    }
  }
}

