package com.biz.crm.sfa.admin.web.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceHistoryPageDto;
import com.biz.crm.sfa.admin.web.report.service.AttendanceHistoryVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceHistoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考勤记录: AttendanceFillApplyVo: 考勤历史
 *
 * @author ning.zhang
 * @date 2022/5/25
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceHistory")
@Api(tags = "考勤记录: AttendanceHistoryVo: 考勤历史")
public class AttendanceHistoryVoController {

  @Autowired
  private AttendanceHistoryVoService attendanceHistoryVoService;

  /**
   * 移动端-考勤历史分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceHistoryVo> 考勤历史分页信息
   */
  @ApiOperation(value = "移动端-考勤历史分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<AttendanceHistoryVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "AttendanceHistoryPageDto", value = "分页Dto") AttendanceHistoryPageDto dto) {
    try {
      return Result.ok(this.attendanceHistoryVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
