package com.biz.crm.sfa.admin.web.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.service.BusinessDynamicVoService;
import com.biz.crm.sfa.admin.web.report.vo.BusinessDynamicVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 业务动态报表
 *
 * @author songjingen
 * @date 2022/7/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/report/businessDynamicVo")
@Api(tags = "业务动态: BusinessDynamicVo: 业务动态")
public class BusinessDynamicVoController {

  @Autowired
  private BusinessDynamicVoService businessDynamicVoService;

  /**
   * 业务动态
   *
   * @param pageable   分页信息
   * @param clientType 客户类型
   * @param clientCode 客户编码
   * @return Page<AttendanceHistoryVo> 考勤历史分页信息
   */
  @ApiOperation(value = "业务动态")
  @GetMapping("/findByClientCodeAndClientType")
  public Result<Page<BusinessDynamicVo>> findByClientCodeAndClientType(@PageableDefault(50) Pageable pageable,
                                                                       @ApiParam(name = "clientCode", value = "客户编码") @RequestParam("clientCode") String clientCode,
                                                                       @ApiParam(name = "clientType", value = "客户类型") @RequestParam("clientType") String clientType) {
    try {
      return Result.ok(this.businessDynamicVoService.findByClientCodeAndClientType(pageable, clientCode, clientType));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
