package com.biz.crm.sfa.admin.web.report.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.service.VisitAnalysisVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 拜访分析统计http接口
 *
 * @author songjingen
 * @date 2022/7/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/report/visitAnalysisVo")
@Api(tags = "拜访分析: VisitAnalysisVo: 业务动态")
public class VisitAnalysisVoController {

  @Autowired
  private VisitAnalysisVoService visitAnalysisVoService;

  /**
   * 拜访分析,根据客户查看近六个月的完成报表
   *
   * @param clientType 客户类型
   * @param clientCode 客户编码
   * @return 拜访分析, 根据客户查看近六个月的完成报表
   */
  @ApiModelProperty("拜访分析,根据客户查看近六个月的报表")
  @GetMapping("findCompletedByClientTypeAndClientCode")
  public Result<Map<String, Long>> findCompletedByClientTypeAndClientCode(@ApiParam(name = "clientCode", value = "客户编码") @RequestParam("clientCode") String clientCode,
                                                                          @ApiParam(name = "clientType", value = "客户类型") @RequestParam("clientType") String clientType) {
    try {
      Map<String, Long> map = this.visitAnalysisVoService.findCompletedByClientTypeAndClientCode(clientType, clientCode);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据用户账号查看近六个月的完成报表
   *
   * @param userName 用户账号
   * @return 根据用户账号查看近六个月的完成报表
   */
  @ApiModelProperty("根据用户账号查看近六个月的完成报表")
  @GetMapping("findCompletedByUserName")
  public Result<Map<String, Long>> findCompletedByUserName(@ApiParam(name = "userName", value = "用户账号") @RequestParam("userName") String userName) {
    try {
      Map<String, Long> map = this.visitAnalysisVoService.findCompletedByUserName(userName);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
