package com.biz.crm.sfa.admin.web.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressDetailDto;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressPageDto;
import com.biz.crm.sfa.admin.web.report.service.VisitCompletionProgressVoService;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressDetailVo;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 拜访完成进度
 * @author: rentao
 * @date: 2022/7/6 14:29
 */
@Slf4j
@RestController
@RequestMapping("/v1/visit/visitCompletionProgress")
@Api(tags = "拜访完成进度: VisitCompletionProgressVo: 拜访完成进度")
public class VisitCompletionProgressVoController {

  @Autowired private VisitCompletionProgressVoService visitCompletionProgressVoService;

  /**
   * 后台-拜访完成进度（天）
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<VisitCompletionProgressVo> 后台-拜访完成进度（天）
   */
  @ApiOperation(value = "后台-拜访完成进度（天）")
  @GetMapping("/findByConditions")
  public Result<Page<VisitCompletionProgressVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "VisitCompletionProgressPageDto", value = "分页Dto") VisitCompletionProgressPageDto dto) {
    try {
      return Result.ok(this.visitCompletionProgressVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 后台-拜访完成进度（月）
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<VisitCompletionProgressVo> 后台-拜访完成进度（月）
   */
  @ApiOperation(value = "后台-拜访完成进度（月）")
  @GetMapping("/findMonthByConditions")
  public Result<Page<VisitCompletionProgressVo>> findMonthByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "VisitCompletionProgressPageDto", value = "分页Dto") VisitCompletionProgressPageDto dto) {
    try {
      return Result.ok(this.visitCompletionProgressVoService.findMonthByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 后台-轨迹
   *
   * @param visitCompletionProgressDetailDto      请求参数dto
   * @return List<VisitCompletionProgressVo>
   */
  @ApiOperation(value = "后台-轨迹")
  @GetMapping("/findTrackByConditions")
  public Result<List<VisitCompletionProgressDetailVo>> findTrackByConditions( @ApiParam(name = "VisitCompletionProgressDetailDto", value = "分页Dto") VisitCompletionProgressDetailDto visitCompletionProgressDetailDto){
    try {
      return Result.ok(this.visitCompletionProgressVoService.findTrackByConditions(visitCompletionProgressDetailDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
