package com.biz.crm.sfa.admin.web.report.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.admin.web.report.dto.VisitPlanDetailReportDto;
import com.biz.crm.sfa.admin.web.report.service.VisitPlanDetailReportVoService;
import com.biz.crm.sfa.admin.web.report.vo.VisitPlanDetailReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 拜访明细报表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@RestController
@RequestMapping("/v1/report/visitPlanDetailReportVo")
@Slf4j
@Api(tags = "拜访明细报表:VisitPlanDetailReportVo:拜访明细报表")
public class VisitPlanDetailReportVoController {

  @Autowired
  private VisitPlanDetailReportVoService visitPlanDetailReportVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<VisitPlanDetailReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                @ApiParam(name = "dto", value = "拜访明细查询dto") VisitPlanDetailReportDto dto) {
    try {
      Page<VisitPlanDetailReportVo> page = this.visitPlanDetailReportVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
