package com.biz.crm.sfa.admin.web.report.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 考勤历史分页Dto
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceHistoryPageDto", description = "考勤历史分页Dto")
public class AttendanceHistoryPageDto extends TenantDto {

  /**
   * 打卡类型(free:自由签到;on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.admin.web.report.enums.AttendanceHistoryClockType
   */
  @ApiModelProperty(value = "打卡类型(free:自由签到;on_work:上班打卡,off_work:下班打卡)")
  private String clockType;

  /**
   * 打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退;error:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @ApiModelProperty(value = "打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退;error:异常)")
  private String clockStatus;

  /**
   * 开始时间
   */
  @ApiModelProperty(value = "开始时间")
  private String startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(value = "结束时间")
  private String endTime;

  /**
   * 查询用户账号集合
   */
  @ApiModelProperty(value = "查询用户账号集合", hidden = true)
  private Set<String> userNames;

  /**
   * 关键字对应人员账号集合
   */
  @ApiModelProperty(value = "关键字对应人员账号集合", hidden = true)
  private Set<String> keyWordUserNames;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyWord;
}
