package com.biz.crm.sfa.admin.web.report.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 考勤明细报表的查询dto
 * @author: rentao
 * @date: 2022/7/5 12:28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRecordDetailPageDto", description = "考勤明细报表的查询dto")
public class AttendanceRecordDetailPageDto extends TenantDto {
  /**
   * 打卡人员账号
   */
  @ApiModelProperty("打卡人员账号")
  private String userName;

  /**
   * 打卡人员名字
   */
  @ApiModelProperty("打卡人员名字")
  private String userRealName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  private String ruleCode;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  private String ruleName;

  /**
   * 打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @ApiModelProperty("打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)")
  private String clockStatus;

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_work:上班打卡,off_work:下班打卡,free 自由签到)")
  private String clockType;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @ApiModelProperty("考勤日期(yyyy-MM-dd)")
  private String ruleDate;

  /**
   * 考勤地址
   */
  @ApiModelProperty("考勤地址")
  private String clockPlace;

  /**
   * 年月
   */
  @ApiModelProperty("年月")
  private String yearMonth;
}
