package com.biz.crm.sfa.admin.web.report.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 拜访明细报表dto
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitPlanDetailReportDto", description = "拜访明细报表dto")
public class VisitPlanDetailReportDto {

  /**
   * 租户编码
   */
  @ApiModelProperty(value = "租户编码", hidden = true)
  private String tenantCode;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 拜访日期(年月查询)
   */
  @ApiModelProperty("拜访日期")
  @DateTimeFormat(pattern = "yyyy-MM")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  private Date visitDateMonth;

  /**
   * 拜访日期(年月查询)
   */
  @ApiModelProperty(value = "拜访日期", hidden = true)
  private String visitDateMonthStr;


}
