package com.biz.crm.sfa.admin.web.report.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤历史打卡类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceHistoryClockType {

  /**
   * 上下班打卡
   */
  FREE("free", "free", "自由签到", "1"),
  /**
   * 上班签到
   */
  OFF_WORK("off_work", "off_work", "下班签退", "2"),
  /**
   * 下班签退
   */
  ON_WORK("on_work", "on_work", "上班签到", "3"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static AttendanceHistoryClockType getByDictCode(String dictCode) {
    AttendanceHistoryClockType result = null;
    for (AttendanceHistoryClockType type : AttendanceHistoryClockType.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
