package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.mapper.AttendanceRecordDetailVoMapper;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceRecordDetailPageDto;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @description: 考勤明细
 * @author: rentao
 * @date: 2022/7/18 16:32
 */
@Component
public class AttendanceRecordDetailRepository {

  @Autowired private AttendanceRecordDetailVoMapper attendanceRecordDetailVoMapper;
  /**
   * 考勤明细报表分页
   *
   * @param pageable 分页参数
   * @return 考勤记录列表
   */
  public Page<AttendanceRecordDetailVo> findDetailByConditions(Pageable pageable,
      AttendanceRecordDetailPageDto dto){
    Page<AttendanceRecordDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.attendanceRecordDetailVoMapper.findDetailByConditions(page, dto);

  }
}
