package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressPageDto;
import com.biz.crm.sfa.admin.web.report.mapper.VisitCompletionProgressVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2022/7/6 14:34
 */
@Component
public class VisitCompletionProgressVoRepository {

  @Autowired private VisitCompletionProgressVoMapper visitCompletionProgressVoMapper;

  /**
   * 考勤历史分页列表 日
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<VisitCompletionProgressVo> 考勤历史分页信息
   */
  public Page<VisitCompletionProgressVo> findByConditions(Pageable pageable, VisitCompletionProgressPageDto dto) {
    Page<VisitCompletionProgressVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.visitCompletionProgressVoMapper.findByConditions(page, dto);
  }

  /**
   * 考勤历史分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<VisitCompletionProgressVo> 考勤历史分页信息
   */
  public Page<VisitCompletionProgressVo> findMonthByConditions(Pageable pageable, VisitCompletionProgressPageDto dto) {
    Page<VisitCompletionProgressVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.visitCompletionProgressVoMapper.findMonthByConditions(page, dto);
  }

  /**
   * 考勤历史分页列表
   *
   * @param dto      请求参数dto
   * @param
   * @return Page<VisitCompletionProgressVo> 考勤历史分页信息
   */
  public List<VisitCompletionProgressVo> findListByConditions(VisitCompletionProgressPageDto dto) {
    return this.visitCompletionProgressVoMapper.findListByConditions(dto);
  }


}
