package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.WorkOverTimePageDto;
import com.biz.crm.sfa.admin.web.report.mapper.WorkOverTimeVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.OvertimeReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 加班报表repository
 */
@Component
public class WorkOverTimeVoRepository {

  @Autowired
  private WorkOverTimeVoMapper workOverTimeVoMapper;

  /**
   * 加班汇总分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceHistoryVo> 加班汇总分页信息
   */
  public Page<OvertimeReportVo> findByConditions(Pageable pageable, WorkOverTimePageDto dto) {
    Page<OvertimeReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.workOverTimeVoMapper.findByConditions(page, dto);
  }
}
