package com.biz.crm.sfa.admin.web.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.repository.AttendanceRecordDetailRepository;
import com.biz.crm.sfa.admin.web.report.service.AttendanceRecordDetailVoService;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordPictureEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordPictureRepository;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceRecordDetailPageDto;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordDetailVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordPictureVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 考勤明细报表的service
 * @author: rentao
 * @date: 2022/7/5 12:26
 */
@Service
@Slf4j
public class AttendanceRecordDetailVoServiceImpl implements AttendanceRecordDetailVoService {

  @Autowired private AttendanceRecordDetailRepository attendanceRecordDetailRepository;
  @Autowired private AttendanceRecordPictureRepository attendanceRecordPictureRepository;
  @Autowired private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<AttendanceRecordDetailVo> findDetailByConditions(Pageable pageable,
      AttendanceRecordDetailPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceRecordDetailPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<AttendanceRecordDetailVo> entityPage = this.attendanceRecordDetailRepository.findDetailByConditions(pageable, dto);
    Page<AttendanceRecordDetailVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    List<AttendanceRecordDetailVo> list = entityPage.getRecords();
    this.perfectPictureInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  /**
   * 完善补打卡申请用户信息
   *
   * @param list 补打卡申请
   */
  private void perfectPictureInfo(List<AttendanceRecordDetailVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    List<String> ids = list.stream().map(AttendanceRecordDetailVo::getId).collect(
        Collectors.toList());
    List<AttendanceRecordPictureEntity> attendanceRecordPictureEntities = this.attendanceRecordPictureRepository.findByRecordIds(ids);
    if (CollectionUtils.isEmpty(attendanceRecordPictureEntities)) {
      return;
    }
    List<AttendanceRecordPictureVo> fileVos = (List<AttendanceRecordPictureVo>)this.nebulaToolkitService
        .copyCollectionByWhiteList(attendanceRecordPictureEntities,
            AttendanceRecordPictureEntity.class
            , AttendanceRecordPictureVo.class, HashSet.class, ArrayList.class);

    Map<String, List<AttendanceRecordPictureVo>> userMap = fileVos.stream().collect(Collectors.groupingBy(AttendanceRecordPictureVo::getRecordId));
    list.forEach(vo -> {
      List<AttendanceRecordPictureVo> pictureVoList = userMap.getOrDefault(vo.getId(), new ArrayList<>());
      vo.setPictureList(pictureVoList);
    });
  }
}
