package com.biz.crm.sfa.admin.web.report.service.internal;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.sfa.admin.web.report.vo.SfaLeaveApplyTimeVo;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.TodayHistoryRecordDto;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceRecordMonthPageDto;
import com.biz.crm.sfa.admin.web.report.repository.AttendanceRecordMonthVoRepository;
import com.biz.crm.sfa.admin.web.report.service.AttendanceRecordMonthVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordMonthVo;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRecordVoService;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRuleVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveDateType;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeTimeType;
import com.biz.crm.sfa.business.overtime.sdk.service.OvertimeApplyVoService;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyTimeVo;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.sfa.leave.local.dto.SfaApplyTimeInfoDto;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveListDto;
import com.biz.crm.sfa.leave.local.service.SfaLeaveVoService;
import com.biz.crm.sfa.leave.local.utils.SfaSignUtils;
import com.biz.crm.sfa.leave.local.vo.SfaLeaveVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 月度考勤
 * @author: rentao
 * @date: 2022/7/4 15:32
 */
@Service
public class AttendanceRecordMonthVoServiceImpl implements AttendanceRecordMonthVoService {

  @Autowired private AttendanceRecordMonthVoRepository attendanceRecordMonthVoRepository;
  @Autowired private UserFeignVoService userFeignVoService;
  @Autowired private AttendanceRecordVoService attendanceRecordVoService;
  @Autowired private OvertimeApplyVoService overtimeApplyVoService;
  @Autowired private AttendanceRuleVoService attendanceRuleVoService;
  @Autowired private SfaLeaveVoService sfaLeaveVoService;
  public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

  @Override
  public Page<AttendanceRecordMonthVo> findByConditions(
      Pageable pageable, AttendanceRecordMonthPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceRecordMonthPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<AttendanceRecordMonthVo> recordMonthVoPage =
        attendanceRecordMonthVoRepository.findByConditions(pageable, dto);
    List<AttendanceRecordMonthVo> attendanceRecordMonthVos = recordMonthVoPage.getRecords();
    this.loadMonthDetail(attendanceRecordMonthVos);
    recordMonthVoPage.setRecords(attendanceRecordMonthVos);
    return recordMonthVoPage;
  }

  /**
   * 加载月度考勤详情 工作时长 工作日+加班 成对的时间 按照小时统计
   * 旷工 在勤 休息 加班 请假 迟到 早退
   *
   * @param list
   */
  private void loadMonthDetail(List<AttendanceRecordMonthVo> list) {
    // 用户每天考勤状态信息
    if (!CollectionUtils.isEmpty(list)) {
      // 账号集合
      Set<String> userNames = list.stream().map(AttendanceRecordMonthVo::getUserName).collect(Collectors.toSet());
      // 考勤记录
      Map<String, List<AttendanceRecordVo>> attendanceRecordMap = this.getAttendanceRecordMap(userNames);
      // 加班
      Map<String, List<OvertimeApplyTimeVo>> overtimeApplyMap = this.getOvertimeApplyVoMap(userNames);
      // 请假
      Map<String, List<SfaLeaveVo>> sfaLeaveVoMap = this.getSfaLeaveVoMap(userNames);
      // 统计 客户 工作时长  迟到 早退的次数 旷工 在勤 休息 次数
      for (AttendanceRecordMonthVo attendanceRecordMonthVo : list) {
        // 客户的所有打卡记录
        String ruleYear = attendanceRecordMonthVo.getRuleYear();
        String ruleMonth =
            attendanceRecordMonthVo.getRuleMonth().compareTo("9") <= 0
                ? String.valueOf("0".concat(attendanceRecordMonthVo.getRuleMonth())) : attendanceRecordMonthVo.getRuleMonth();
        String yearMonth = ruleYear.concat("-").concat(ruleMonth);
        // 考勤记录
        List<AttendanceRecordVo> attendanceRecordVoList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(attendanceRecordMap.get(attendanceRecordMonthVo.getUserName()))){
          attendanceRecordVoList.addAll(attendanceRecordMap.get(attendanceRecordMonthVo.getUserName()).stream()
              .filter(attendanceRecordVo -> attendanceRecordVo.getRuleDate().startsWith(yearMonth)).collect(Collectors.toList()));
        }
        // 加班
        List<OvertimeApplyTimeVo> overtimeApplyTimeVos = new ArrayList<>();
        if(!CollectionUtils.isEmpty(overtimeApplyMap.get(attendanceRecordMonthVo.getUserName()))){
          overtimeApplyTimeVos.addAll(overtimeApplyMap.get(attendanceRecordMonthVo.getUserName()).stream()
              .filter(attendanceRecordVo -> attendanceRecordVo.getItemTime().startsWith(yearMonth)).collect(Collectors.toList()));
        }
        //请假
        List<SfaLeaveVo> sfaLeaveVos = new ArrayList<>();
        if(!CollectionUtils.isEmpty(sfaLeaveVoMap.get(attendanceRecordMonthVo.getUserName()))){
          sfaLeaveVos.addAll(sfaLeaveVoMap.get(attendanceRecordMonthVo.getUserName()).stream()
              .filter(sfaLeaveVo -> sfaLeaveVo.getBeginTime().startsWith(yearMonth)).collect(Collectors.toList()));
        }
        //数据组装
        this.setOvertimeDays(overtimeApplyTimeVos, attendanceRecordMonthVo);
        this.setAllTimes(overtimeApplyTimeVos,attendanceRecordVoList,attendanceRecordMonthVo);
        this.setLateDaysAndEarlyDays(attendanceRecordVoList,attendanceRecordMonthVo);
        this.setLeaveDays(sfaLeaveVos,attendanceRecordMonthVo,yearMonth);
        this.setOffDays(attendanceRecordVoList,attendanceRecordMonthVo);
        this.setNormal(attendanceRecordVoList,attendanceRecordMonthVo);
        this.setAbsenteeismDays(attendanceRecordVoList,attendanceRecordMonthVo);
      }
    }
  }

  /**
   * 获取时间毫秒值
   *
   * @param startDateStr
   * @param endStarDateStr
   * @author rentao
   * @date a
  */
  public int calLastedTime(String startDateStr, String endStarDateStr) {
    try {
      Date startDate = DateUtils.parseDate(startDateStr, YYYY_MM_DD_HH_MM_SS);
      Date endStarDate = DateUtils.parseDate(endStarDateStr, YYYY_MM_DD_HH_MM_SS);
      long endStarDateTime = endStarDate.getTime();
      long startDateTime = startDate.getTime();
      if (endStarDate.compareTo(startDate) > 0) {
        int c = (int) ((endStarDateTime - startDateTime) / (1000));
        return c;
      } else {
        int c = (int) ((startDateTime - endStarDateTime) / (1000));
        return c;
      }
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return 0;
  }

  // 获取时间断日历
  private List<String> getEveryDay(Date startTime, Date endTime) {
    List<String> days = new ArrayList<>();
    Calendar cal = Calendar.getInstance();
    cal.setTime(startTime);
    while (cal.getTime().compareTo(endTime) <= 0) {
      if(cal.getTime().compareTo(endTime) == 0){
        days.add(DateFormatUtils.format(cal.getTime(), "yyyy-MM-dd"));
        cal.add(Calendar.DAY_OF_MONTH, 1);
      }else {
        days.add(DateFormatUtils.format(cal.getTime(), "yyyy-MM-dd"));
        cal.add(Calendar.DAY_OF_MONTH, 1);
        days.add(DateFormatUtils.format(cal.getTime(), "yyyy-MM-dd"));
      }
    }
    return days;
  }

  /**
   * 获取考勤记录 map
   *
   * @param userNames
   * @author rentao
   * @date a
   */
  private Map<String, List<AttendanceRecordVo>> getAttendanceRecordMap(Set<String> userNames) {
    Map<String, List<AttendanceRecordVo>> attendanceRecordMap = new HashMap<>();
    if(!CollectionUtils.isEmpty(userNames)){
      TodayHistoryRecordDto todayHistoryRecordDto = new TodayHistoryRecordDto();
      todayHistoryRecordDto.setUserNames(userNames);
      List<AttendanceRecordVo> attendanceRecordVos = this.attendanceRecordVoService.findByHistoryRecordDto(todayHistoryRecordDto);
      if(!CollectionUtils.isEmpty(attendanceRecordVos)){
        attendanceRecordMap.putAll(attendanceRecordVos.stream()
            .collect(Collectors.groupingBy(AttendanceRecordVo::getUserName, Collectors.toList())));
      }
    }
    return attendanceRecordMap;
  }

  /**
   * 获取加班记录 map
   *
   * @param userNames
   * @author rentao
   * @date a
   */
  private Map<String, List<OvertimeApplyTimeVo>> getOvertimeApplyVoMap(Set<String> userNames) {
    Map<String, List<OvertimeApplyTimeVo>> attendanceRecordMap = new HashMap<>();
    if(!CollectionUtils.isEmpty(userNames)){
      OvertimeApplyConditionDto applyConditionDto = new OvertimeApplyConditionDto();
      applyConditionDto.setIncludeProcessStatusList(Collections.singletonList(ActApproveStatusEnum.APPROVED.getCode()));
      applyConditionDto.setUserNames(userNames);
      List<OvertimeApplyTimeVo> overtimeApplyVos = this.overtimeApplyVoService.findOvertimeApplyTimeByConditions(applyConditionDto);
      if(!CollectionUtils.isEmpty(overtimeApplyVos)){
        attendanceRecordMap.putAll(overtimeApplyVos.stream()
            .collect(Collectors.groupingBy(OvertimeApplyTimeVo::getUserName, Collectors.toList())));
      }
    }
    return attendanceRecordMap;
  }

  /**
   * 获取请假记录 map
   *
   * @param userNames
   * @author rentao
   * @date a
   */
  private Map<String, List<SfaLeaveVo>> getSfaLeaveVoMap(Set<String> userNames) {
    Map<String, List<SfaLeaveVo>> attendanceRecordMap = new HashMap<>();
    if(!CollectionUtils.isEmpty(userNames)){
      SfaLeaveListDto sfaLeaveListDto = new SfaLeaveListDto();
      sfaLeaveListDto.setUserNames(userNames);
      sfaLeaveListDto.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
      List<SfaLeaveVo> sfaLeaveVos = this.sfaLeaveVoService.findByConditions(sfaLeaveListDto);
      if(!CollectionUtils.isEmpty(sfaLeaveVos)){
        attendanceRecordMap.putAll(sfaLeaveVos.stream()
            .collect(Collectors.groupingBy(SfaLeaveVo::getUserName, Collectors.toList())));
      }
    }
    return attendanceRecordMap;
  }

  /**
   * 组装加班数据 从加班表里获取当月加班的审批通过数据 累计起来
   *
   * @param overtimeApplyTimeVos 加班数据
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setOvertimeDays(List<OvertimeApplyTimeVo> overtimeApplyTimeVos, AttendanceRecordMonthVo attendanceRecordMonthVo) {
    BigDecimal overtimeDays = BigDecimal.ZERO;
    if (!CollectionUtils.isEmpty(overtimeApplyTimeVos)) {
      for (OvertimeApplyTimeVo overtimeApplyTimeVo : overtimeApplyTimeVos) {
        if (OvertimeTimeType.ALL_DAY.getDictCode().equals(overtimeApplyTimeVo.getTimeType())) {
          overtimeDays = overtimeDays.add(BigDecimal.ONE);
        } else {
          overtimeDays = overtimeDays.add(BigDecimal.valueOf(0.5));
        }
      }
    }
    attendanceRecordMonthVo.setOvertimeDays(overtimeDays);
  }

  /**
   * 组装工作时长 小时
   * 工作日+加班 成对的时间 按照小时统计
   * @param overtimeApplyTimeVos 加班数据
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setAllTimes(List<OvertimeApplyTimeVo> overtimeApplyTimeVos,List<AttendanceRecordVo> attendanceRecordVoList,AttendanceRecordMonthVo attendanceRecordMonthVo) {
    List<String> overtime = overtimeApplyTimeVos.stream().map(OvertimeApplyTimeVo::getItemTime).collect(Collectors.toList());
    Map<String, List<AttendanceRecordVo>> workingDayattendanceRecordMap =
        attendanceRecordVoList.stream()
            .filter(
                attendanceRecordVo ->
                    BooleanEnum.TRUE.getCapital().equals(attendanceRecordVo.getExecuteAsWorkingDay())
                        && StringUtils.isNotBlank(attendanceRecordVo.getClockTime()))
            .collect(Collectors.groupingBy((item) -> item.getRuleDate() + "_" + item.getRuleTimeId() + "_" + BooleanEnum.TRUE.getCapital()));
    // 加班成对时间
    if (!CollectionUtils.isEmpty(overtime)) {
      Map<String, List<AttendanceRecordVo>> noWorkingDayattendanceRecordVosMap =
          attendanceRecordVoList.stream().filter(attendanceRecordVo ->
                      BooleanEnum.FALSE.getCapital().equals(attendanceRecordVo.getExecuteAsWorkingDay())
                      && StringUtils.isNotBlank(attendanceRecordVo.getClockTime())
                      && overtime.contains(attendanceRecordVo.getRuleDate()))
              .collect(Collectors.groupingBy((item) -> item.getRuleDate() + "_" + item.getRuleTimeId() + "_" + BooleanEnum.FALSE.getCapital()));
      workingDayattendanceRecordMap.putAll(noWorkingDayattendanceRecordVosMap);
    }
    // 秒
    BigDecimal allTimesSecond = BigDecimal.ZERO;
    if (CollectionUtils.isEmpty(workingDayattendanceRecordMap)) {
      attendanceRecordMonthVo.setAllTimes(BigDecimal.ZERO);
    } else {
      for (String key : workingDayattendanceRecordMap.keySet()) {
        List<AttendanceRecordVo> attendanceRecordVos = workingDayattendanceRecordMap.get(key);
        if (attendanceRecordVos.size() == 2) {
          AttendanceRecordVo attendanceRecordVoStart = attendanceRecordVos.get(0);
          AttendanceRecordVo attendanceRecordVoEnd = attendanceRecordVos.get(1);
          String ruleDate = attendanceRecordVoStart.getRuleDate();
          String clockTimeStart =
              ruleDate.concat(" ").concat(attendanceRecordVoStart.getClockTime());
          String clockTimeEnd =
              ruleDate.concat(" ").concat(attendanceRecordVoEnd.getClockTime());
          int i = calLastedTime(clockTimeStart, clockTimeEnd);
          allTimesSecond = allTimesSecond.add(BigDecimal.valueOf(i));
        }
      }
    }
    BigDecimal allTimes = allTimesSecond.divide(BigDecimal.valueOf(3600), 2, BigDecimal.ROUND_HALF_UP).setScale(2, RoundingMode.HALF_UP);
    attendanceRecordMonthVo.setAllTimes(allTimes);
  }


  /**
   * 组装迟到早退 考勤表里打卡状态为迟到 早退的数据
   * 考勤表里打卡状态为迟到 早退的数据
   * @param attendanceRecordVoList 加班数据
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setLateDaysAndEarlyDays(List<AttendanceRecordVo> attendanceRecordVoList,AttendanceRecordMonthVo attendanceRecordMonthVo) {
    Map<String,Long>  attendanceRecordCountMap = attendanceRecordVoList.stream().collect(Collectors.groupingBy(AttendanceRecordVo::getClockStatus, Collectors.counting()));
    //be_late:迟到;leave_early:早退
    Long beLate = attendanceRecordCountMap.get(AttendanceClockStatus.BE_LATE.getDictCode()) == null ?0L: attendanceRecordCountMap.get(AttendanceClockStatus.BE_LATE.getDictCode());
    Long leaveEarly = attendanceRecordCountMap.get(AttendanceClockStatus.LEAVE_EARLY.getDictCode())== null ?0L: attendanceRecordCountMap.get(AttendanceClockStatus.LEAVE_EARLY.getDictCode());
    attendanceRecordMonthVo.setLateDays(Math.toIntExact(beLate));
    attendanceRecordMonthVo.setEarlyDays(Math.toIntExact(leaveEarly));
  }


  /**
   * 组装休息   计算逻辑 非工作日天数 - 加班天数 = 休息 存在负数归零
   *
   * @param attendanceRecordVoList 考勤明细
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setOffDays(List<AttendanceRecordVo> attendanceRecordVoList,AttendanceRecordMonthVo attendanceRecordMonthVo) {
    Set<String> workingDay =
        attendanceRecordVoList.stream()
            .filter(
                attendanceRecordVo ->
                    BooleanEnum.FALSE.getCapital().equals(attendanceRecordVo.getExecuteAsWorkingDay())).map(AttendanceRecordVo::getRuleDate).collect(Collectors.toSet());
    BigDecimal offDays = BigDecimal.valueOf(workingDay.size()).subtract(attendanceRecordMonthVo.getOvertimeDays());
    if(offDays.compareTo(BigDecimal.ZERO)>0){
      attendanceRecordMonthVo.setOffDays(offDays);
    }else {
      attendanceRecordMonthVo.setOffDays(BigDecimal.ZERO);
    }
  }
 /**
   * 组装正常出勤  正常出勤 计算逻辑  考勤明细中 工作日只要打了卡 累计一天
   *
   * @param attendanceRecordVoList 加班数据
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setNormal(List<AttendanceRecordVo> attendanceRecordVoList,AttendanceRecordMonthVo attendanceRecordMonthVo) {
    BigDecimal normal =BigDecimal.ZERO;
    Map<String, List<AttendanceRecordVo>> workingDayattendanceRecordMap =
        attendanceRecordVoList.stream()
            .filter(
                attendanceRecordVo ->
                    BooleanEnum.TRUE.getCapital().equals(attendanceRecordVo.getExecuteAsWorkingDay())
                        && StringUtils.isNotBlank(attendanceRecordVo.getClockTime()))
            .collect(Collectors.groupingBy((item) -> item.getRuleDate()));
    if(!CollectionUtils.isEmpty(workingDayattendanceRecordMap)){
      for (String ruleDate:workingDayattendanceRecordMap.keySet()){
        List<AttendanceRecordVo> attendanceRecordVos = workingDayattendanceRecordMap.get(ruleDate);
        if(!CollectionUtils.isEmpty(attendanceRecordVos)){
          List<AttendanceRecordVo> onWork = attendanceRecordVos.stream().filter(attendanceRecordVo -> AttendanceClockType.ON_WORK.getDictCode().equals(attendanceRecordVo.getClockType())).collect(Collectors.toList());
          List<AttendanceRecordVo> offWork = attendanceRecordVos.stream().filter(attendanceRecordVo -> AttendanceClockType.OFF_WORK.getDictCode().equals(attendanceRecordVo.getClockType())).collect(Collectors.toList());
          if(!CollectionUtils.isEmpty(onWork) ||  !CollectionUtils.isEmpty(offWork)){
            normal = normal.add(BigDecimal.ONE);
          }
        }
      }
    }
    attendanceRecordMonthVo.setNormal(normal);
  }



  /**
   * 组装矿工  旷工计算逻辑  考勤明细中工作日（天）的考勤记录没有打卡记录矿工
   *
   * @param attendanceRecordVoList
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setAbsenteeismDays(List<AttendanceRecordVo> attendanceRecordVoList,AttendanceRecordMonthVo attendanceRecordMonthVo) {
    BigDecimal absenteeismDays =BigDecimal.ZERO;
    Map<String, List<AttendanceRecordVo>> workingDayattendanceRecordMap =
        attendanceRecordVoList.stream()
            .filter(
                attendanceRecordVo ->
                    BooleanEnum.TRUE.getCapital().equals(attendanceRecordVo.getExecuteAsWorkingDay()))
            .collect(Collectors.groupingBy((item) -> item.getRuleDate()));
    if(!CollectionUtils.isEmpty(workingDayattendanceRecordMap)){
      for (String ruleDate:workingDayattendanceRecordMap.keySet()){
        List<AttendanceRecordVo> attendanceRecordVos = workingDayattendanceRecordMap.get(ruleDate);
        if(!CollectionUtils.isEmpty(attendanceRecordVos)){
          //打卡记录
          List<AttendanceRecordVo> onWork = attendanceRecordVos.stream().filter(attendanceRecordVo -> AttendanceClockType.ON_WORK.getDictCode().equals(attendanceRecordVo.getClockType()) && StringUtils.isNotBlank(attendanceRecordVo.getClockTime())).collect(Collectors.toList());
          List<AttendanceRecordVo> offWork = attendanceRecordVos.stream().filter(attendanceRecordVo -> AttendanceClockType.OFF_WORK.getDictCode().equals(attendanceRecordVo.getClockType()) && StringUtils.isNotBlank(attendanceRecordVo.getClockTime())).collect(Collectors.toList());
          if(CollectionUtils.isEmpty(onWork) && CollectionUtils.isEmpty(offWork)){
            absenteeismDays = absenteeismDays.add(BigDecimal.ONE);
          }
        }
      }
    }
    attendanceRecordMonthVo.setAbsenteeismDays(absenteeismDays);
  }

  /**
   * 组装请假数据  获取到考勤规则 根据考勤规则计算排除非工作日 统计当月的数据  如果没有考勤规则默认 请假周期都统计
   *
   * @param sfaLeaveVos 请假数据
   * @param attendanceRecordMonthVo 月统计数据vo
   * @author rentao
   * @date a
   */
  private void setLeaveDays(List<SfaLeaveVo> sfaLeaveVos,AttendanceRecordMonthVo attendanceRecordMonthVo,String yearMonth) {
    BigDecimal leaveDays = BigDecimal.ZERO;
    //那些天是请假的
    Set<String> everyDay = new HashSet<>();
    //开始结束 特殊的天数
    List<SfaLeaveApplyTimeVo> leaveApplyTimeVos = new ArrayList<>();
    //需要排除的天数
    List<SfaLeaveApplyTimeVo> nonWorkleaveApplyTimeVos = new ArrayList<>();
    // 拿到开始日期是本月的请假审批通过的数据
    for (SfaLeaveVo sfaLeaveVo : sfaLeaveVos) {
      if(StringUtils.isNotBlank(sfaLeaveVo.getTimeInfoListJson())){
        leaveApplyTimeVos.addAll(JSON.parseArray(sfaLeaveVo.getTimeInfoListJson(), SfaLeaveApplyTimeVo.class));
      }
      if(StringUtils.isNotBlank(sfaLeaveVo.getNonWorkDateListJson())){
        nonWorkleaveApplyTimeVos.addAll(JSON.parseArray(sfaLeaveVo.getNonWorkDateListJson(), SfaLeaveApplyTimeVo.class));
      }
      try {
        Date beginTime = DateUtils.parseDate(sfaLeaveVo.getBeginTime(), "yyyy-MM-dd");
        Date endTime  = DateUtils.parseDate(sfaLeaveVo.getEndTime(), "yyyy-MM-dd");
        Date lastDayOfMonth = this.getLastDayOfMonth(beginTime);
        if(lastDayOfMonth.compareTo(endTime) > 0){
          List<String> list = this.getEveryDay(beginTime, endTime);
          everyDay.addAll(list.stream().filter(s -> s.startsWith(yearMonth)).collect(Collectors.toList()));
        }else {
          List<String> list = this.getEveryDay(beginTime,lastDayOfMonth);
          everyDay.addAll(list.stream().filter(s -> s.startsWith(yearMonth)).collect(Collectors.toList()));
        }
      } catch (ParseException e) {
        e.printStackTrace();
      }
    }
    for (String day : everyDay) {
      //特殊天数
      List<SfaLeaveApplyTimeVo> applyTimeVos = leaveApplyTimeVos.stream().filter(sfaLeaveApplyTimeVo -> sfaLeaveApplyTimeVo.getTimeStr().equals(day)).collect(Collectors.toList());
      if(!CollectionUtils.isEmpty(applyTimeVos)){
        if(applyTimeVos.size() == 1){
          if (LeaveDateType.ALL_DAY.getDictCode().equals(applyTimeVos.get(0).getTimeType())){
            leaveDays = leaveDays.add(BigDecimal.ONE);
          }else {
            leaveDays = leaveDays.add(BigDecimal.valueOf(0.5));
          }
        }else {
          leaveDays = leaveDays.add(BigDecimal.ONE);
        }
      }else {
        leaveDays = leaveDays.add(BigDecimal.ONE);
      }
    }
    //排除非工作日
    if(!CollectionUtils.isEmpty(nonWorkleaveApplyTimeVos)){
      for (SfaLeaveApplyTimeVo sfaLeaveApplyTimeVo:nonWorkleaveApplyTimeVos){
        if (LeaveDateType.ALL_DAY.getDictCode().equals(sfaLeaveApplyTimeVo.getTimeType())){
          leaveDays = leaveDays.subtract(BigDecimal.ONE);
        }else {
          leaveDays = leaveDays.subtract(BigDecimal.valueOf(0.5));
        }
      }
    }
    attendanceRecordMonthVo.setLeaveDays(leaveDays);
  }




  /**
   * 获取指定年月的最后一天
   * @param reconciliationLetterMonth
   * @return
   */
  private Date getLastDayOfMonth(Date reconciliationLetterMonth) {
    Calendar cal = Calendar.getInstance();
    cal.setTime(reconciliationLetterMonth);
    //获取月最大天数
    int lastDay = cal.getActualMaximum(Calendar.DATE);
    //设置日历中月份的最大天数
    cal.set(Calendar.DAY_OF_MONTH,lastDay);
    cal.set(Calendar.HOUR_OF_DAY,23);
    cal.set(Calendar.MINUTE,59);
    cal.set(Calendar.SECOND,59);
    cal.set(Calendar.MILLISECOND,999);
    return cal.getTime();
  }
}
